import type { HttpError } from '../../../util/http';
import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class RubyVersionDatasource extends Datasource {
    static readonly id = "ruby-version";
    constructor();
    readonly defaultRegistryUrls: string[];
    readonly customRegistrySupport = false;
    readonly defaultVersioning = "ruby";
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `release-list` table in the results.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "We use the URL: https://github.com/ruby/ruby.";
    getReleases({ registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    handleHttpErrors(err: HttpError): never | void;
}
