"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonRelease = void 0;
const zod_1 = require("zod");
const timestamp_1 = require("../../../util/timestamp");
exports.PythonRelease = zod_1.z
    .object({
    /** e.g: "Python 3.9.0b1" */
    name: zod_1.z.string(),
    /** e.g: "python-390b1" */
    slug: zod_1.z.string(),
    /** Major version e.g: 3 */
    version: zod_1.z.number(),
    /** is latest major version, true for Python 2.7.18 and latest Python 3 */
    is_latest: zod_1.z.boolean(),
    is_published: zod_1.z.boolean(),
    release_date: timestamp_1.MaybeTimestamp,
    pre_release: zod_1.z.boolean(),
    release_page: zod_1.z.string().nullable(),
    show_on_download_page: zod_1.z.boolean(),
    /** Changelog e.g: "https://docs.python.org/…html#python-3-9-0-beta-1" */
    release_notes_url: zod_1.z.string(),
    /** Download URL e.g: "https://www.python.org/api/v2/downloads/release/436/" */
    resource_uri: zod_1.z.string(),
})
    .transform(({ name, release_date: releaseTimestamp, pre_release }) => {
    const version = name?.replace('Python', '').trim();
    const isStable = pre_release === false;
    return { version, releaseTimestamp, isStable };
})
    .array();
//# sourceMappingURL=schema.js.map