import type { Http } from '../../../util/http';
import type { ReleaseResult } from '../types';
import type { CatalogEntry, CatalogPage } from './types';
export declare class NugetV3Api {
    static readonly cacheNamespace = "datasource-nuget-v3";
    getResourceUrl(http: Http, url: string, resourceType?: string): Promise<string | null>;
    getCatalogEntry(http: Http, catalogPage: CatalogPage): Promise<CatalogEntry[]>;
    getReleases(http: Http, registryUrl: string, feedUrl: string, pkgName: string): Promise<ReleaseResult | null>;
    getSourceUrlFromNupkg(http: Http, _registryUrl: string, packageName: string, packageVersion: string | null, nupkgUrl: string): Promise<string | null>;
    getDeprecationMessage(packageName: string): string;
}
