"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NpmDatasource = exports.setNpmrc = void 0;
const tslib_1 = require("tslib");
const npmVersioning = tslib_1.__importStar(require("../../versioning/npm"));
const datasource_1 = require("../datasource");
const common_1 = require("./common");
const get_1 = require("./get");
var npmrc_1 = require("./npmrc");
Object.defineProperty(exports, "setNpmrc", { enumerable: true, get: function () { return npmrc_1.setNpmrc; } });
class NpmDatasource extends datasource_1.Datasource {
    static id = 'npm';
    customRegistrySupport = true;
    registryStrategy = 'first';
    defaultVersioning = npmVersioning.id;
    defaultRegistryUrls = common_1.defaultRegistryUrls;
    releaseTimestampSupport = true;
    releaseTimestampNote = 'The release timestamp is determined from the `time` field in the results.';
    sourceUrlSupport = 'release';
    sourceUrlNote = 'The source URL is determined from the `repository` field in the results.';
    constructor() {
        super(NpmDatasource.id);
    }
    async getReleases({ packageName, registryUrl, }) {
        /* v8 ignore next 3 -- should never happen */
        if (!registryUrl) {
            return null;
        }
        const res = await (0, get_1.getDependency)(this.http, registryUrl, packageName);
        return res;
    }
}
exports.NpmDatasource = NpmDatasource;
//# sourceMappingURL=index.js.map