import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export { setNpmrc } from './npmrc';
export declare class NpmDatasource extends Datasource {
    static readonly id = "npm";
    readonly customRegistrySupport = true;
    readonly registryStrategy = "first";
    readonly defaultVersioning = "npm";
    readonly defaultRegistryUrls: string[];
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `time` field in the results.";
    readonly sourceUrlSupport = "release";
    readonly sourceUrlNote = "The source URL is determined from the `repository` field in the results.";
    constructor();
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
