import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class HexpmBobDatasource extends Datasource {
    static readonly id = "hexpm-bob";
    constructor();
    readonly customRegistrySupport = true;
    readonly defaultRegistryUrls: string[];
    readonly caching = true;
    readonly defaultVersioning = "semver";
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `buildDate` field in the results.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "We use the URL https://github.com/elixir-lang/elixir.git for the `elixir` package and the https://github.com/erlang/otp.git URL for the `erlang` package.";
    getReleases({ registryUrl, packageName, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    private static getPackageType;
    private static cleanVersion;
    private static isStable;
    private static getPackageDetails;
}
