"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HexRelease = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
const timestamp_1 = require("../../../util/timestamp");
exports.HexRelease = zod_1.z
    .object({
    html_url: zod_1.z.string().optional(),
    meta: zod_1.z
        .object({
        links: zod_1.z
            .record(zod_1.z.string())
            .transform((links) => Object.fromEntries(Object.entries(links).map(([key, value]) => [
            key.toLowerCase(),
            value,
        ])))
            .pipe(zod_1.z.object({
            github: zod_1.z.string(),
        })),
    })
        .nullable()
        .catch(null),
    releases: (0, schema_utils_1.LooseArray)(zod_1.z.object({
        version: zod_1.z.string(),
        inserted_at: timestamp_1.MaybeTimestamp,
    })).refine((releases) => releases.length > 0, 'No releases found'),
    retirements: zod_1.z
        .record(zod_1.z.string(), zod_1.z.object({
        message: zod_1.z.string().nullable(),
        reason: zod_1.z.string(),
    }))
        .optional(),
})
    .transform((hexResponse) => {
    const releases = hexResponse.releases.map(({ version, inserted_at: releaseTimestamp }) => {
        const release = { version };
        if (releaseTimestamp) {
            release.releaseTimestamp = releaseTimestamp;
        }
        if (is_1.default.plainObject(hexResponse.retirements?.[version])) {
            release.isDeprecated = true;
        }
        return release;
    });
    const releaseResult = { releases };
    if (hexResponse.html_url) {
        releaseResult.homepage = hexResponse.html_url;
    }
    if (hexResponse.meta?.links?.github) {
        releaseResult.sourceUrl = hexResponse.meta.links.github;
    }
    return releaseResult;
});
//# sourceMappingURL=schema.js.map