"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HexDatasource = void 0;
const tslib_1 = require("tslib");
const logger_1 = require("../../../logger");
const decorator_1 = require("../../../util/cache/package/decorator");
const url_1 = require("../../../util/url");
const hexVersioning = tslib_1.__importStar(require("../../versioning/hex"));
const datasource_1 = require("../datasource");
const schema_1 = require("./schema");
class HexDatasource extends datasource_1.Datasource {
    static id = 'hex';
    constructor() {
        super(HexDatasource.id);
    }
    defaultRegistryUrls = ['https://hex.pm'];
    defaultVersioning = hexVersioning.id;
    releaseTimestampSupport = true;
    releaseTimestampNote = 'The release timestamp is determined the `inserted_at` field in the results.';
    sourceUrlSupport = 'package';
    sourceUrlNote = 'The source URL is determined from the `Github` field in the results.';
    async getReleases({ packageName, registryUrl, }) {
        /* v8 ignore next 3 -- should never happen */
        if (!registryUrl) {
            return null;
        }
        // Get dependency name from packageName.
        // If the dependency is private packageName contains organization name as following:
        // hexPackageName:organizationName
        // hexPackageName is used to pass it in hex dep url
        // organizationName is used for accessing to private deps
        const [hexPackageName, organizationName] = packageName.split(':');
        const organizationUrlPrefix = organizationName
            ? `repos/${organizationName}/`
            : '';
        const hexUrl = (0, url_1.joinUrlParts)(registryUrl, `/api/${organizationUrlPrefix}packages/${hexPackageName}`);
        const { val: result, err } = await this.http
            .getJsonSafe(hexUrl, schema_1.HexRelease)
            .onError((err) => {
            logger_1.logger.warn({ url: hexUrl, datasource: 'hex', packageName, err }, 'Error fetching from url');
        })
            .unwrap();
        if (err) {
            this.handleGenericErrors(err);
        }
        return result;
    }
}
exports.HexDatasource = HexDatasource;
tslib_1.__decorate([
    (0, decorator_1.cache)({
        namespace: `datasource-${HexDatasource.id}`,
        key: ({ packageName }) => packageName,
    })
], HexDatasource.prototype, "getReleases", null);
//# sourceMappingURL=index.js.map