import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
import type { HelmRepositoryData } from './schema';
export declare class HelmDatasource extends Datasource {
    static readonly id = "helm";
    constructor();
    readonly defaultRegistryUrls: string[];
    readonly defaultConfig: {
        commitMessageTopic: string;
    };
    readonly defaultVersioning = "helm";
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timstamp is determined from the `created` field in the results.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is determined from the `home` field or the `sources` field in the results.";
    getRepositoryData(helmRepository: string): Promise<HelmRepositoryData>;
    getReleases({ packageName, registryUrl: helmRepository, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
