"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HackageDatasource = void 0;
exports.versionToRelease = versionToRelease;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const url_1 = require("../../../util/url");
const pvpVersioning = tslib_1.__importStar(require("../../versioning/pvp"));
const datasource_1 = require("../datasource");
const schema_1 = require("./schema");
class HackageDatasource extends datasource_1.Datasource {
    static id = 'hackage';
    constructor() {
        super(HackageDatasource.id);
    }
    defaultVersioning = pvpVersioning.id;
    customRegistrySupport = false;
    defaultRegistryUrls = ['https://hackage.haskell.org/'];
    async getReleases(config) {
        const { registryUrl, packageName } = config;
        if (!is_1.default.nonEmptyString(registryUrl)) {
            return null;
        }
        const massagedPackageName = encodeURIComponent(packageName);
        const url = (0, url_1.joinUrlParts)(registryUrl, 'package', `${massagedPackageName}.json`);
        const res = await this.http.getJson(url, schema_1.HackagePackageMetadata);
        const releases = [];
        for (const [version, versionStatus] of Object.entries(res.body)) {
            const isDeprecated = versionStatus === 'deprecated';
            releases.push(versionToRelease(version, packageName, registryUrl, isDeprecated));
        }
        return { releases };
    }
}
exports.HackageDatasource = HackageDatasource;
function versionToRelease(version, packageName, registryUrl, isDeprecated) {
    return {
        version,
        changelogUrl: (0, url_1.joinUrlParts)(registryUrl, 'package', `${packageName}-${version}`, 'changelog'),
        isDeprecated,
    };
}
//# sourceMappingURL=index.js.map