import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class GradleVersionDatasource extends Datasource {
    static readonly id = "gradle-version";
    constructor();
    readonly defaultRegistryUrls: string[];
    readonly defaultVersioning = "gradle";
    readonly registryStrategy = "merge";
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `buildTime` field in the results.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "We use the URL: https://github.com/gradle/gradle.";
    getReleases({ registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    /**
     * Calculate `gitTag` based on `version`:
     *   - `8.1.2` -> `v8.1.2`
     *   - `8.2` -> `v8.2.0`
     *   - `8.2-rc-1` -> `v8.2.0-RC1`
     *   - `8.2-milestone-1` -> `v8.2.0-M1`
     */
    private static getGitRef;
}
