import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class GolangVersionDatasource extends Datasource {
    static readonly id = "golang-version";
    constructor();
    readonly defaultRegistryUrls: string[];
    readonly customRegistrySupport = true;
    readonly defaultVersioning = "semver";
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `Date` field in the results.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "We use the URL: https://github.com/golang/go.";
    getReleases({ registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
