import { Datasource } from '../datasource';
import type { GetReleasesConfig, Release, ReleaseResult } from '../types';
import { GoDirectDatasource } from './releases-direct';
export declare function pseudoVersionToRelease(pseudoVersion: string): Release | null;
export declare class GoProxyDatasource extends Datasource {
    static readonly id = "go-proxy";
    constructor();
    readonly direct: GoDirectDatasource;
    getReleases(config: GetReleasesConfig): Promise<ReleaseResult | null>;
    /**
     * Avoid ambiguity when serving from case-insensitive file systems.
     *
     * @see https://golang.org/ref/mod#goproxy-protocol
     */
    encodeCase(input: string): string;
    listVersions(baseUrl: string, packageName: string): Promise<Release[]>;
    versionInfo(baseUrl: string, packageName: string, version: string): Promise<Release>;
    getLatestVersion(baseUrl: string, packageName: string): Promise<string | null>;
    getVersionsWithInfo(baseUrl: string, packageName: string): Promise<ReleaseResult>;
    static getCacheKey({ packageName }: GetReleasesConfig): string;
}
