import { BitbucketTagsDatasource } from '../bitbucket-tags';
import { Datasource } from '../datasource';
import { GitTagsDatasource } from '../git-tags';
import { GiteaTagsDatasource } from '../gitea-tags';
import { GithubTagsDatasource } from '../github-tags';
import { GitlabTagsDatasource } from '../gitlab-tags';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class GoDirectDatasource extends Datasource {
    static readonly id = "go-direct";
    git: GitTagsDatasource;
    readonly gitea: GiteaTagsDatasource;
    github: GithubTagsDatasource;
    gitlab: GitlabTagsDatasource;
    bitbucket: BitbucketTagsDatasource;
    constructor();
    /**
     * go.getReleases
     *
     * This datasource resolves a go module URL into its source repository
     *  and then fetch it if it is on GitHub.
     *
     * This function will:
     *  - Determine the source URL for the module
     *  - Call the respective getReleases in github/gitlab to retrieve the tags
     *  - Filter module tags according to the module path
     */
    getReleases(config: GetReleasesConfig): Promise<ReleaseResult | null>;
}
