import { Datasource } from '../datasource';
import type { DigestConfig, GetReleasesConfig, ReleaseResult } from '../types';
import { GoDirectDatasource } from './releases-direct';
import { GoProxyDatasource } from './releases-goproxy';
export declare class GoDatasource extends Datasource {
    static readonly id = "go";
    readonly defaultVersioning = "semver";
    constructor();
    readonly defaultConfig: {
        commitMessageTopic: string;
    };
    readonly customRegistrySupport = false;
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "If the release timestamp is not returned from the respective datasoure used to fetch the releases, then Renovate uses the `Time` field in the results instead.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is determined from the `packageName` and `registryUrl`.";
    readonly goproxy: GoProxyDatasource;
    readonly direct: GoDirectDatasource;
    static readonly pversionRegexp: RegExp;
    getReleases(config: GetReleasesConfig): Promise<ReleaseResult | null>;
    /**
     * go.getDigest
     *
     * This datasource resolves a go module URL into its source repository
     *  and then fetches the digest if it is on GitHub.
     *
     * This function will:
     *  - Determine the source URL for the module
     *  - Call the respective getDigest in github to retrieve the commit hash
     */
    getDigest({ packageName }: DigestConfig, newValue?: string): Promise<string | null>;
}
