"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlasskubePackagesDatasource = void 0;
const tslib_1 = require("tslib");
const decorator_1 = require("../../../util/cache/package/decorator");
const url_1 = require("../../../util/url");
const glasskubeVersioning = tslib_1.__importStar(require("../../versioning/glasskube"));
const datasource_1 = require("../datasource");
const schema_1 = require("./schema");
class GlasskubePackagesDatasource extends datasource_1.Datasource {
    static id = 'glasskube-packages';
    static defaultRegistryUrl = 'https://packages.dl.glasskube.dev/packages';
    customRegistrySupport = true;
    defaultVersioning = glasskubeVersioning.id;
    defaultRegistryUrls = [
        GlasskubePackagesDatasource.defaultRegistryUrl,
    ];
    constructor() {
        super(GlasskubePackagesDatasource.id);
    }
    async getReleases({ packageName, registryUrl, }) {
        const result = { releases: [] };
        const { val: versions, err: versionsErr } = await this.http
            .getYamlSafe((0, url_1.joinUrlParts)(registryUrl, packageName, 'versions.yaml'), schema_1.GlasskubePackageVersions)
            .unwrap();
        if (versionsErr) {
            this.handleGenericErrors(versionsErr);
        }
        result.releases = versions.versions.map((it) => ({
            version: it.version,
        }));
        result.tags = { latest: versions.latestVersion };
        const { val: latestManifest, err: latestManifestErr } = await this.http
            .getYamlSafe((0, url_1.joinUrlParts)(registryUrl, packageName, versions.latestVersion, 'package.yaml'), schema_1.GlasskubePackageManifest)
            .unwrap();
        if (latestManifestErr) {
            this.handleGenericErrors(latestManifestErr);
        }
        for (const ref of latestManifest?.references ?? []) {
            if (ref.label.toLowerCase() === 'github') {
                result.sourceUrl = ref.url;
            }
            else if (ref.label.toLowerCase() === 'website') {
                result.homepage = ref.url;
            }
        }
        return result;
    }
}
exports.GlasskubePackagesDatasource = GlasskubePackagesDatasource;
tslib_1.__decorate([
    (0, decorator_1.cache)({
        namespace: `datasource-${GlasskubePackagesDatasource.id}`,
        key: ({ registryUrl, packageName }) => `${registryUrl}:${packageName}`,
    })
], GlasskubePackagesDatasource.prototype, "getReleases", null);
//# sourceMappingURL=index.js.map