import { GithubHttp } from '../../../util/http/github';
import { Datasource } from '../datasource';
import type { DigestConfig, GetReleasesConfig, ReleaseResult } from '../types';
export declare const cacheNamespace = "datasource-github-releases";
export declare class GithubReleasesDatasource extends Datasource {
    static readonly id = "github-releases";
    readonly defaultRegistryUrls: string[];
    http: GithubHttp;
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `releaseTimestamp` field from the response.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is determined by using the `packageName` and `registryUrl`.";
    constructor();
    /**
     * Attempts to resolve the digest for the specified package.
     *
     * The `newValue` supplied here should be a valid tag for the GitHub release. The digest
     * of a GitHub release will be the underlying SHA of the release tag.
     *
     * Some managers like Bazel will deal with individual artifacts from releases and handle
     * the artifact checksum computation separately. This data-source does not know about
     * specific artifacts being used, as that could vary per manager
     */
    getDigest({ packageName: repo, currentValue, currentDigest, registryUrl, }: DigestConfig, newValue: string): Promise<string | null>;
    /**
     * This function can be used to fetch releases with a customizable versioning
     * (e.g. semver) and with releases.
     *
     * This function will:
     *  - Fetch all releases
     *  - Sanitize the versions if desired (e.g. strip out leading 'v')
     *  - Return a dependency object containing sourceUrl string and releases array
     */
    getReleases(config: GetReleasesConfig): Promise<ReleaseResult>;
}
