"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagsSchema = exports.TagSchema = exports.CommitsSchema = exports.CommitSchema = void 0;
const zod_1 = require("zod");
const timestamp_1 = require("../../../util/timestamp");
exports.CommitSchema = zod_1.z.object({
    sha: zod_1.z.string(),
});
exports.CommitsSchema = zod_1.z.array(exports.CommitSchema);
const TagCommitSchema = zod_1.z.object({
    sha: zod_1.z.string(),
    created: timestamp_1.MaybeTimestamp,
});
exports.TagSchema = zod_1.z.object({
    name: zod_1.z.string(),
    commit: TagCommitSchema,
});
exports.TagsSchema = zod_1.z.array(exports.TagSchema);
//# sourceMappingURL=schema.js.map