import { z } from 'zod';
export declare const CommitSchema: z.ZodObject<{
    sha: z.ZodString;
}, "strip", z.ZodTypeAny, {
    sha: string;
}, {
    sha: string;
}>;
export declare const CommitsSchema: z.ZodArray<z.ZodObject<{
    sha: z.ZodString;
}, "strip", z.ZodTypeAny, {
    sha: string;
}, {
    sha: string;
}>, "many">;
export declare const TagSchema: z.ZodObject<{
    name: z.ZodString;
    commit: z.ZodObject<{
        sha: z.ZodString;
        created: z.ZodCatch<z.ZodNullable<z.ZodEffects<z.ZodUnknown, import("../../../util/timestamp").Timestamp, unknown>>>;
    }, "strip", z.ZodTypeAny, {
        created: import("../../../util/timestamp").Timestamp | null;
        sha: string;
    }, {
        sha: string;
        created?: unknown;
    }>;
}, "strip", z.ZodTypeAny, {
    commit: {
        created: import("../../../util/timestamp").Timestamp | null;
        sha: string;
    };
    name: string;
}, {
    commit: {
        sha: string;
        created?: unknown;
    };
    name: string;
}>;
export declare const TagsSchema: z.ZodArray<z.ZodObject<{
    name: z.ZodString;
    commit: z.ZodObject<{
        sha: z.ZodString;
        created: z.ZodCatch<z.ZodNullable<z.ZodEffects<z.ZodUnknown, import("../../../util/timestamp").Timestamp, unknown>>>;
    }, "strip", z.ZodTypeAny, {
        created: import("../../../util/timestamp").Timestamp | null;
        sha: string;
    }, {
        sha: string;
        created?: unknown;
    }>;
}, "strip", z.ZodTypeAny, {
    commit: {
        created: import("../../../util/timestamp").Timestamp | null;
        sha: string;
    };
    name: string;
}, {
    commit: {
        sha: string;
        created?: unknown;
    };
    name: string;
}>, "many">;
