"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitRefsDatasource = void 0;
const tslib_1 = require("tslib");
const logger_1 = require("../../../logger");
const decorator_1 = require("../../../util/cache/package/decorator");
const regex_1 = require("../../../util/regex");
const base_1 = require("./base");
// git will prompt for known hosts or passwords, unless we activate BatchMode
process.env.GIT_SSH_COMMAND = 'ssh -o BatchMode=yes';
class GitRefsDatasource extends base_1.GitDatasource {
    static id = 'git-refs';
    constructor() {
        super(GitRefsDatasource.id);
    }
    customRegistrySupport = false;
    sourceUrlSupport = 'package';
    sourceUrlNote = 'The source URL is determined by using the `packageName` and `registryUrl`.';
    async getReleases({ packageName, }) {
        let rawRefs = null;
        try {
            rawRefs = await this.getRawRefs({ packageName });
        }
        catch (err) /* istanbul ignore next */ {
            logger_1.logger.debug({ err }, 'Error getting git-refs');
        }
        if (!rawRefs) {
            return null;
        }
        const refs = rawRefs
            .filter((ref) => ref.type === 'tags' || ref.type === 'heads')
            .map((ref) => ref.value);
        const uniqueRefs = [...new Set(refs)];
        const sourceUrl = packageName
            .replace((0, regex_1.regEx)(/\.git$/), '')
            .replace((0, regex_1.regEx)(/\/$/), '');
        const result = {
            sourceUrl,
            releases: uniqueRefs.map((ref) => ({
                version: ref,
                gitRef: ref,
                newDigest: rawRefs.find((rawRef) => rawRef.value === ref)?.hash,
            })),
        };
        return result;
    }
    async getDigest({ packageName }, newValue) {
        const rawRefs = await this.getRawRefs({ packageName });
        /* v8 ignore next 3 -- TODO: add test */
        if (!rawRefs) {
            return null;
        }
        let ref;
        if (newValue) {
            ref = rawRefs.find((rawRef) => ['heads', 'tags'].includes(rawRef.type) && rawRef.value === newValue);
        }
        else {
            ref = rawRefs.find((rawRef) => rawRef.type === '' && rawRef.value === 'HEAD');
        }
        if (ref) {
            return ref.hash;
        }
        return null;
    }
}
exports.GitRefsDatasource = GitRefsDatasource;
tslib_1.__decorate([
    (0, decorator_1.cache)({
        namespace: `datasource-${GitRefsDatasource.id}`,
        key: ({ packageName }) => packageName,
    })
], GitRefsDatasource.prototype, "getReleases", null);
//# sourceMappingURL=index.js.map