"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GalaxyV1 = void 0;
const zod_1 = require("zod");
const timestamp_1 = require("../../../util/timestamp");
exports.GalaxyV1 = zod_1.z.object({
    results: zod_1.z.array(zod_1.z.object({
        summary_fields: zod_1.z.object({
            versions: zod_1.z.array(zod_1.z
                .object({
                name: zod_1.z.string(),
                created: timestamp_1.MaybeTimestamp,
            })
                .transform(({ name, created }) => ({
                version: name,
                releaseTimestamp: created,
            }))),
        }),
        github_user: zod_1.z.string().optional(),
        github_repo: zod_1.z.string().optional(),
    })),
});
//# sourceMappingURL=schema.js.map