import { z } from 'zod';
export type GalaxyV1 = z.infer<typeof GalaxyV1>;
export declare const GalaxyV1: z.ZodObject<{
    results: z.ZodArray<z.ZodObject<{
        summary_fields: z.ZodObject<{
            versions: z.ZodArray<z.ZodEffects<z.ZodObject<{
                name: z.ZodString;
                created: z.ZodCatch<z.ZodNullable<z.ZodEffects<z.ZodUnknown, import("../../../util/timestamp").Timestamp, unknown>>>;
            }, "strip", z.ZodTypeAny, {
                created: import("../../../util/timestamp").Timestamp | null;
                name: string;
            }, {
                name: string;
                created?: unknown;
            }>, {
                version: string;
                releaseTimestamp: import("../../../util/timestamp").Timestamp | null;
            }, {
                name: string;
                created?: unknown;
            }>, "many">;
        }, "strip", z.ZodTypeAny, {
            versions: {
                version: string;
                releaseTimestamp: import("../../../util/timestamp").Timestamp | null;
            }[];
        }, {
            versions: {
                name: string;
                created?: unknown;
            }[];
        }>;
        github_user: z.ZodOptional<z.ZodString>;
        github_repo: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        summary_fields: {
            versions: {
                version: string;
                releaseTimestamp: import("../../../util/timestamp").Timestamp | null;
            }[];
        };
        github_user?: string | undefined;
        github_repo?: string | undefined;
    }, {
        summary_fields: {
            versions: {
                name: string;
                created?: unknown;
            }[];
        };
        github_user?: string | undefined;
        github_repo?: string | undefined;
    }>, "many">;
}, "strip", z.ZodTypeAny, {
    results: {
        summary_fields: {
            versions: {
                version: string;
                releaseTimestamp: import("../../../util/timestamp").Timestamp | null;
            }[];
        };
        github_user?: string | undefined;
        github_repo?: string | undefined;
    }[];
}, {
    results: {
        summary_fields: {
            versions: {
                name: string;
                created?: unknown;
            }[];
        };
        github_user?: string | undefined;
        github_repo?: string | undefined;
    }[];
}>;
