"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndoflifeDateVersions = void 0;
const luxon_1 = require("luxon");
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
const timestamp_1 = require("../../../util/timestamp");
const ExpireableField = zod_1.z.union([
    schema_utils_1.UtcDate.transform((x) => {
        const now = luxon_1.DateTime.now().toUTC();
        return x <= now;
    }),
    zod_1.z.boolean(),
]);
exports.EndoflifeDateVersions = zod_1.z
    .object({
    cycle: zod_1.z.string(),
    latest: zod_1.z.optional(zod_1.z.string()),
    releaseDate: timestamp_1.MaybeTimestamp,
    eol: zod_1.z.optional(ExpireableField),
    discontinued: zod_1.z.optional(ExpireableField),
})
    .transform(({ cycle, latest, releaseDate: releaseTimestamp, eol, discontinued, }) => {
    const version = latest ?? cycle;
    const isDeprecated = eol === true || discontinued === true;
    return { version, releaseTimestamp, isDeprecated };
})
    .array();
//# sourceMappingURL=schema.js.map