"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DotnetRuntimeReleases = exports.DotnetSdkReleases = exports.ReleasesIndex = void 0;
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
const timestamp_1 = require("../../../util/timestamp");
exports.ReleasesIndex = zod_1.z
    .object({
    'releases-index': (0, schema_utils_1.LooseArray)(zod_1.z
        .object({
        'releases.json': zod_1.z.string(),
    })
        .transform(({ 'releases.json': releasesUrl }) => releasesUrl)).catch([]),
})
    .transform(({ 'releases-index': releasesIndex }) => releasesIndex);
const ReleaseBase = zod_1.z.object({
    'release-date': timestamp_1.MaybeTimestamp,
    'release-notes': zod_1.z.string(),
});
const ReleaseDetails = zod_1.z.object({
    version: zod_1.z.string(),
});
exports.DotnetSdkReleases = zod_1.z
    .object({
    releases: (0, schema_utils_1.LooseArray)(ReleaseBase.extend({
        sdks: zod_1.z.array(ReleaseDetails),
    })).catch([]),
})
    .transform(({ releases }) => releases.flatMap(({ sdks, 'release-date': releaseTimestamp, 'release-notes': changelogUrl, }) => sdks.map(({ version }) => ({
    version,
    releaseTimestamp,
    changelogUrl,
}))));
exports.DotnetRuntimeReleases = zod_1.z
    .object({
    releases: (0, schema_utils_1.LooseArray)(ReleaseBase.extend({
        runtime: ReleaseDetails,
    })).catch([]),
})
    .transform(({ releases }) => releases.map(({ runtime: { version }, 'release-date': releaseTimestamp, 'release-notes': changelogUrl, }) => ({ version, releaseTimestamp, changelogUrl })));
//# sourceMappingURL=schema.js.map