import { z } from 'zod';
import type { Release } from '../types';
export declare const ReleasesIndex: z.ZodEffects<z.ZodObject<{
    'releases-index': z.ZodCatch<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, string[], any[]>>;
}, "strip", z.ZodTypeAny, {
    'releases-index': string[];
}, {
    'releases-index'?: unknown;
}>, string[], {
    'releases-index'?: unknown;
}>;
export declare const DotnetSdkReleases: z.ZodEffects<z.ZodObject<{
    releases: z.ZodCatch<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        'release-date': import("../../../util/timestamp").Timestamp | null;
        'release-notes': string;
        sdks: {
            version: string;
        }[];
    }[], any[]>>;
}, "strip", z.ZodTypeAny, {
    releases: {
        'release-date': import("../../../util/timestamp").Timestamp | null;
        'release-notes': string;
        sdks: {
            version: string;
        }[];
    }[];
}, {
    releases?: unknown;
}>, Release[], {
    releases?: unknown;
}>;
export declare const DotnetRuntimeReleases: z.ZodEffects<z.ZodObject<{
    releases: z.ZodCatch<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        runtime: {
            version: string;
        };
        'release-date': import("../../../util/timestamp").Timestamp | null;
        'release-notes': string;
    }[], any[]>>;
}, "strip", z.ZodTypeAny, {
    releases: {
        runtime: {
            version: string;
        };
        'release-date': import("../../../util/timestamp").Timestamp | null;
        'release-notes': string;
    }[];
}, {
    releases?: unknown;
}>, Release[], {
    releases?: unknown;
}>;
