"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DotnetVersionDatasource = void 0;
const tslib_1 = require("tslib");
const decorator_1 = require("../../../util/cache/package/decorator");
const p = tslib_1.__importStar(require("../../../util/promises"));
const datasource_1 = require("../datasource");
const schema_1 = require("./schema");
class DotnetVersionDatasource extends datasource_1.Datasource {
    static id = 'dotnet-version';
    constructor() {
        super(DotnetVersionDatasource.id);
    }
    caching = true;
    customRegistrySupport = false;
    defaultRegistryUrls = [
        'https://dotnetcli.blob.core.windows.net/dotnet/release-metadata/releases-index.json',
    ];
    releaseTimestampSupport = true;
    releaseTimestampNote = 'The release timestamp is determined from the `release-date` field in the results.';
    sourceUrlSupport = 'package';
    sourceUrlNote = 'We use the URL https://github.com/dotnet/sdk for the `dotnet-sdk` package and, the https://github.com/dotnet/runtime URL for the `dotnet-runtime` package.';
    async getReleases({ packageName, }) {
        if (!(packageName === 'dotnet-sdk' || packageName === 'dotnet-runtime')) {
            return null;
        }
        try {
            const registryUrl = this.defaultRegistryUrls[0];
            const { body: urls } = await this.http.getJson(registryUrl, schema_1.ReleasesIndex);
            const channelReleases = await p.map(urls, (url) => this.getChannelReleases(url, packageName), { concurrency: 1, stopOnError: true });
            const releases = channelReleases.flat();
            const sourceUrl = packageName === 'dotnet-sdk'
                ? 'https://github.com/dotnet/sdk'
                : 'https://github.com/dotnet/runtime';
            return { releases, sourceUrl };
        }
        catch (err) {
            this.handleGenericErrors(err);
        }
    }
    async getChannelReleases(releaseUrl, packageName) {
        const schema = packageName === 'dotnet-sdk' ? schema_1.DotnetSdkReleases : schema_1.DotnetRuntimeReleases;
        try {
            const { body } = await this.http.getJson(releaseUrl, schema);
            return body;
        }
        catch (err) {
            this.handleGenericErrors(err);
        }
    }
}
exports.DotnetVersionDatasource = DotnetVersionDatasource;
tslib_1.__decorate([
    (0, decorator_1.cache)({
        namespace: `datasource-${DotnetVersionDatasource.id}`,
        key: ({ packageName }) => packageName,
        ttlMinutes: 1440,
    })
], DotnetVersionDatasource.prototype, "getReleases", null);
tslib_1.__decorate([
    (0, decorator_1.cache)({
        namespace: `datasource-${DotnetVersionDatasource.id}`,
        key: (releaseUrl, packageName) => `${releaseUrl}:${packageName}`,
        ttlMinutes: 1440,
    })
], DotnetVersionDatasource.prototype, "getChannelReleases", null);
//# sourceMappingURL=index.js.map