import type { Http } from '../../../util/http';
import type { HttpResponse, OutgoingHttpHeaders } from '../../../util/http/types';
import type { OciHelmConfig } from './schema';
import type { RegistryRepository } from './types';
export declare const dockerDatasourceId = "docker";
export declare const imageUrlLabel = "org.opencontainers.image.url";
export declare const sourceLabel = "org.opencontainers.image.source";
export declare const sourceLabels: readonly ["org.opencontainers.image.source", "org.label-schema.vcs-url"];
export declare const gitRefLabel = "org.opencontainers.image.revision";
export declare const DOCKER_HUB = "https://index.docker.io";
export declare function isDockerHost(host: string): boolean;
export declare function getAuthHeaders(http: Http, registryHost: string, dockerRepository: string, apiCheckUrl?: string): Promise<OutgoingHttpHeaders | null>;
export declare function getRegistryRepository(packageName: string, registryUrl: string): RegistryRepository;
export declare function extractDigestFromResponseBody(manifestResponse: HttpResponse): string;
export declare function findLatestStable(tags: string[]): string | null;
export declare function findHelmSourceUrl(release: OciHelmConfig): string | null;
