"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevboxResponse = exports.DevboxRelease = void 0;
const zod_1 = require("zod");
const timestamp_1 = require("../../../util/timestamp");
exports.DevboxRelease = zod_1.z.object({
    version: zod_1.z.string(),
    last_updated: timestamp_1.MaybeTimestamp,
});
exports.DevboxResponse = zod_1.z
    .object({
    name: zod_1.z.string(),
    summary: zod_1.z.string().optional(),
    homepage_url: zod_1.z.string().optional(),
    license: zod_1.z.string().optional(),
    releases: exports.DevboxRelease.array(),
})
    .transform((response) => ({
    name: response.name,
    homepage: response.homepage_url,
    releases: response.releases.map((release) => ({
        version: release.version,
        releaseTimestamp: release.last_updated,
    })),
}));
//# sourceMappingURL=schema.js.map