import { z } from 'zod';
export declare const DevboxRelease: z.ZodObject<{
    version: z.ZodString;
    last_updated: z.ZodCatch<z.ZodNullable<z.ZodEffects<z.ZodUnknown, import("../../../util/timestamp").Timestamp, unknown>>>;
}, "strip", z.ZodTypeAny, {
    version: string;
    last_updated: import("../../../util/timestamp").Timestamp | null;
}, {
    version: string;
    last_updated?: unknown;
}>;
export declare const DevboxResponse: z.ZodEffects<z.ZodObject<{
    name: z.ZodString;
    summary: z.ZodOptional<z.ZodString>;
    homepage_url: z.ZodOptional<z.ZodString>;
    license: z.ZodOptional<z.ZodString>;
    releases: z.ZodArray<z.ZodObject<{
        version: z.ZodString;
        last_updated: z.ZodCatch<z.ZodNullable<z.ZodEffects<z.ZodUnknown, import("../../../util/timestamp").Timestamp, unknown>>>;
    }, "strip", z.ZodTypeAny, {
        version: string;
        last_updated: import("../../../util/timestamp").Timestamp | null;
    }, {
        version: string;
        last_updated?: unknown;
    }>, "many">;
}, "strip", z.ZodTypeAny, {
    name: string;
    releases: {
        version: string;
        last_updated: import("../../../util/timestamp").Timestamp | null;
    }[];
    summary?: string | undefined;
    homepage_url?: string | undefined;
    license?: string | undefined;
}, {
    name: string;
    releases: {
        version: string;
        last_updated?: unknown;
    }[];
    summary?: string | undefined;
    homepage_url?: string | undefined;
    license?: string | undefined;
}>, {
    name: string;
    homepage: string | undefined;
    releases: {
        version: string;
        releaseTimestamp: import("../../../util/timestamp").Timestamp | null;
    }[];
}, {
    name: string;
    releases: {
        version: string;
        last_updated?: unknown;
    }[];
    summary?: string | undefined;
    homepage_url?: string | undefined;
    license?: string | undefined;
}>;
