import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class DevboxDatasource extends Datasource {
    static readonly id = "devbox";
    constructor();
    readonly customRegistrySupport = true;
    readonly releaseTimestampSupport = true;
    readonly registryStrategy = "first";
    readonly defaultVersioning = "devbox";
    readonly defaultRegistryUrls: string[];
    getReleases({ registryUrl, packageName, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
