"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DenoAPIModuleVersionResponse = exports.DenoAPIUploadOptions = exports.DenoAPIModuleResponse = exports.DenoApiTag = void 0;
const zod_1 = require("zod");
const url_1 = require("../../../util/github/url");
const schema_utils_1 = require("../../../util/schema-utils");
const timestamp_1 = require("../../../util/timestamp");
exports.DenoApiTag = zod_1.z.object({
    kind: zod_1.z.string(),
    value: zod_1.z.string(),
});
exports.DenoAPIModuleResponse = zod_1.z.object({
    tags: (0, schema_utils_1.LooseArray)(exports.DenoApiTag)
        .transform((tags) => {
        const record = {};
        for (const { kind, value } of tags) {
            record[kind] = value;
        }
        return record;
    })
        .catch({}),
    versions: zod_1.z.array(zod_1.z.string()),
});
exports.DenoAPIUploadOptions = zod_1.z.object({
    ref: zod_1.z.string(),
    type: zod_1.z.union([zod_1.z.literal('github'), zod_1.z.unknown()]),
    repository: zod_1.z.string(),
    subdir: zod_1.z.string().optional(),
});
exports.DenoAPIModuleVersionResponse = zod_1.z
    .object({
    upload_options: exports.DenoAPIUploadOptions,
    uploaded_at: timestamp_1.MaybeTimestamp,
    version: zod_1.z.string(),
})
    .transform(({ version, uploaded_at: releaseTimestamp, upload_options }) => {
    let sourceUrl = undefined;
    const { type, repository, ref: gitRef } = upload_options;
    if (type === 'github') {
        sourceUrl = (0, url_1.getSourceUrl)(repository);
    }
    return {
        version,
        gitRef,
        releaseTimestamp,
        sourceUrl,
    };
});
//# sourceMappingURL=schema.js.map