import { z } from 'zod';
import type { Release } from '../types';
export declare const DenoApiTag: z.ZodObject<{
    kind: z.ZodString;
    value: z.ZodString;
}, "strip", z.ZodTypeAny, {
    value: string;
    kind: string;
}, {
    value: string;
    kind: string;
}>;
export declare const DenoAPIModuleResponse: z.ZodObject<{
    tags: z.ZodCatch<z.ZodEffects<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        value: string;
        kind: string;
    }[], any[]>, Record<string, string>, any[]>>;
    versions: z.ZodArray<z.ZodString, "many">;
}, "strip", z.ZodTypeAny, {
    versions: string[];
    tags: Record<string, string>;
}, {
    versions: string[];
    tags?: unknown;
}>;
export declare const DenoAPIUploadOptions: z.ZodObject<{
    ref: z.ZodString;
    type: z.ZodUnion<[z.ZodLiteral<"github">, z.ZodUnknown]>;
    repository: z.ZodString;
    subdir: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    ref: string;
    repository: string;
    type?: unknown;
    subdir?: string | undefined;
}, {
    ref: string;
    repository: string;
    type?: unknown;
    subdir?: string | undefined;
}>;
export declare const DenoAPIModuleVersionResponse: z.ZodEffects<z.ZodObject<{
    upload_options: z.ZodObject<{
        ref: z.ZodString;
        type: z.ZodUnion<[z.ZodLiteral<"github">, z.ZodUnknown]>;
        repository: z.ZodString;
        subdir: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        ref: string;
        repository: string;
        type?: unknown;
        subdir?: string | undefined;
    }, {
        ref: string;
        repository: string;
        type?: unknown;
        subdir?: string | undefined;
    }>;
    uploaded_at: z.ZodCatch<z.ZodNullable<z.ZodEffects<z.ZodUnknown, import("../../../util/timestamp").Timestamp, unknown>>>;
    version: z.ZodString;
}, "strip", z.ZodTypeAny, {
    version: string;
    upload_options: {
        ref: string;
        repository: string;
        type?: unknown;
        subdir?: string | undefined;
    };
    uploaded_at: import("../../../util/timestamp").Timestamp | null;
}, {
    version: string;
    upload_options: {
        ref: string;
        repository: string;
        type?: unknown;
        subdir?: string | undefined;
    };
    uploaded_at?: unknown;
}>, Release, {
    version: string;
    upload_options: {
        ref: string;
        repository: string;
        type?: unknown;
        subdir?: string | undefined;
    };
    uploaded_at?: unknown;
}>;
