/**
 * Extracts the specified compressed file to the output file.
 *
 * @param compressedFile - The path to the compressed file.
 * @param compression - The compression method used (currently only 'gz' is supported).
 * @param outputFile - The path where the extracted content will be stored.
 * @throws Will throw an error if the compression method is unknown.
 */
export declare function extract(compressedFile: string, compression: string, outputFile: string): Promise<void>;
/**
 * Checks if the file exists and retrieves its creation time.
 *
 * @param filePath - The path to the file.
 * @returns The creation time if the file exists, otherwise undefined.
 */
export declare function getFileCreationTime(filePath: string): Promise<Date | undefined>;
