/**
 * Parses the SHA256 checksum for a specified package path from the InRelease content.
 *
 * @param inReleaseContent - content of the InRelease file
 * @param packagePath - path of the package file (e.g., 'contrib/binary-amd64/Packages.gz')
 * @returns The SHA256 checksum if found, otherwise undefined
 */
export declare function parseChecksumsFromInRelease(inReleaseContent: string, packagePath: string): string | null;
/**
 * Computes the SHA256 checksum of a specified file.
 *
 * @param filePath - path of the file
 * @returns resolves to the SHA256 checksum
 */
export declare function computeFileChecksum(filePath: string): Promise<string>;
