import { Http, HttpError } from '../../util/http';
import type { DatasourceApi, DigestConfig, GetReleasesConfig, PostprocessReleaseConfig, PostprocessReleaseResult, RegistryStrategy, Release, ReleaseResult, SourceUrlSupport } from './types';
export declare abstract class Datasource implements DatasourceApi {
    readonly id: string;
    protected constructor(id: string);
    caching: boolean | undefined;
    customRegistrySupport: boolean;
    defaultConfig: Record<string, unknown> | undefined;
    defaultRegistryUrls?: string[] | (() => string[]);
    defaultVersioning?: string | undefined;
    registryStrategy: RegistryStrategy | undefined;
    releaseTimestampSupport: boolean;
    releaseTimestampNote?: string | undefined;
    sourceUrlSupport: SourceUrlSupport;
    sourceUrlNote?: string | undefined;
    protected http: Http;
    abstract getReleases(getReleasesConfig: GetReleasesConfig): Promise<ReleaseResult | null>;
    getDigest?(config: DigestConfig, newValue?: string): Promise<string | null>;
    handleHttpErrors(_err: HttpError): void;
    protected handleGenericErrors(err: Error): never;
    postprocessRelease(_config: PostprocessReleaseConfig, release: Release): Promise<PostprocessReleaseResult>;
}
