import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare const stableVersionRegex: RegExp;
/**
 * The server returns old svn versions which would need mapping to a version.
 * They are very old, so we skip them instead.
 * https://github.com/dart-lang/site-www/blob/7d4409c87bb6570b2d8870b20283f81f2b7e08fc/tool/get-dart/dart_sdk_archive/lib/src/svn_versions.dart#L2
 */
export declare const svnVersionRegex: RegExp;
export declare class DartVersionDatasource extends Datasource {
    static readonly id = "dart-version";
    constructor();
    readonly customRegistrySupport = false;
    readonly defaultRegistryUrls: string[];
    readonly caching = true;
    private readonly channels;
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "We use the URL: https://github.com/dart-lang/sdk.";
    getReleases({ registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    private getReleasesFromResponse;
    private getVersionFromPrefix;
}
