"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.massageCustomDatasourceConfig = massageCustomDatasourceConfig;
exports.getCustomConfig = getCustomConfig;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../logger");
const template = tslib_1.__importStar(require("../../../util/template"));
function massageCustomDatasourceConfig(customDatasourceName, { customDatasources, packageName, currentValue, registryUrl: defaultRegistryUrl, }) {
    const customDatasource = customDatasources?.[customDatasourceName];
    if (is_1.default.nullOrUndefined(customDatasource)) {
        logger_1.logger.debug(`No custom datasource config provided while ${packageName} has been requested`);
        return null;
    }
    const templateInput = { packageName, currentValue };
    const registryUrlTemplate = defaultRegistryUrl ?? customDatasource.defaultRegistryUrlTemplate;
    if (is_1.default.nullOrUndefined(registryUrlTemplate)) {
        logger_1.logger.debug('No registry url provided by extraction nor datasource configuration');
        return null;
    }
    const registryUrl = template.compile(registryUrlTemplate, templateInput);
    const transformTemplates = customDatasource.transformTemplates ?? [];
    const transform = [];
    for (const transformTemplate of transformTemplates) {
        const templated = template.compile(transformTemplate, templateInput);
        transform.push(templated);
    }
    logger_1.logger.trace({ transform }, `Custom datasource compiled data.`);
    return {
        format: customDatasource.format ?? 'json',
        defaultRegistryUrlTemplate: registryUrl,
        transformTemplates: transform,
    };
}
function getCustomConfig(getReleasesConfig) {
    const customDatasourceName = getReleasesConfig.datasource?.replace('custom.', '');
    if (!is_1.default.nonEmptyString(customDatasourceName)) {
        logger_1.logger.debug(`No datasource has been supplied while looking up ${getReleasesConfig.packageName}`);
        return null;
    }
    return massageCustomDatasourceConfig(customDatasourceName, getReleasesConfig);
}
//# sourceMappingURL=utils.js.map