"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.YamlFetcher = void 0;
const fs_1 = require("../../../../util/fs");
const yaml_1 = require("../../../../util/yaml");
class YamlFetcher {
    async fetch(http, registryURL) {
        const response = await http.getText(registryURL);
        return (0, yaml_1.parseSingleYaml)(response.body);
    }
    async readFile(registryURL) {
        const fileContent = await (0, fs_1.readLocalFile)(registryURL, 'utf8');
        return (0, yaml_1.parseSingleYaml)(fileContent);
    }
}
exports.YamlFetcher = YamlFetcher;
//# sourceMappingURL=yaml.js.map