"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TomlFetcher = void 0;
const fs_1 = require("../../../../util/fs");
const toml_1 = require("../../../../util/toml");
class TomlFetcher {
    async fetch(http, registryURL) {
        const response = await http.getToml(registryURL);
        return response.body;
    }
    async readFile(registryURL) {
        const fileContent = await (0, fs_1.readLocalFile)(registryURL, 'utf8');
        return (0, toml_1.parse)(fileContent);
    }
}
exports.TomlFetcher = TomlFetcher;
//# sourceMappingURL=toml.js.map