"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JSONFetcher = void 0;
const fs_1 = require("../../../../util/fs");
class JSONFetcher {
    async fetch(http, registryURL) {
        const response = await http.getJsonUnchecked(registryURL);
        return response.body;
    }
    async readFile(registryURL) {
        const fileContent = await (0, fs_1.readLocalFile)(registryURL, 'utf8');
        return JSON.parse(fileContent);
    }
}
exports.JSONFetcher = JSONFetcher;
//# sourceMappingURL=json.js.map