"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PagedResponseSchema = exports.File = void 0;
const zod_1 = require("zod");
exports.File = zod_1.z.object({
    version: zod_1.z.string(),
    createdAt: zod_1.z.string().nullable(),
    yankedReason: zod_1.z.string().nullable(),
    urls: zod_1.z
        .array(zod_1.z.object({ url: zod_1.z.string(), kind: zod_1.z.string() }))
        .optional()
        .default([])
        .transform((urls) => {
        return Object.fromEntries(urls.map((url) => [url.kind, url.url]));
    }),
});
exports.PagedResponseSchema = zod_1.z.object({
    data: zod_1.z.object({
        package: zod_1.z
            .object({
            variants: zod_1.z
                .object({
                pages: zod_1.z.number(),
                page: zod_1.z.array(exports.File),
            })
                .nullable(),
        })
            .nullable(),
    }),
});
//# sourceMappingURL=prefix-dev.js.map