import { z } from 'zod';
export declare const File: z.ZodObject<{
    version: z.ZodString;
    createdAt: z.ZodNullable<z.ZodString>;
    yankedReason: z.ZodNullable<z.ZodString>;
    urls: z.ZodEffects<z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodObject<{
        url: z.ZodString;
        kind: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        kind: string;
    }, {
        url: string;
        kind: string;
    }>, "many">>>, {
        [k: string]: string;
    }, {
        url: string;
        kind: string;
    }[] | undefined>;
}, "strip", z.ZodTypeAny, {
    urls: {
        [k: string]: string;
    };
    version: string;
    createdAt: string | null;
    yankedReason: string | null;
}, {
    version: string;
    createdAt: string | null;
    yankedReason: string | null;
    urls?: {
        url: string;
        kind: string;
    }[] | undefined;
}>;
export type File = z.infer<typeof File>;
export declare const PagedResponseSchema: z.ZodObject<{
    data: z.ZodObject<{
        package: z.ZodNullable<z.ZodObject<{
            variants: z.ZodNullable<z.ZodObject<{
                pages: z.ZodNumber;
                page: z.ZodArray<z.ZodObject<{
                    version: z.ZodString;
                    createdAt: z.ZodNullable<z.ZodString>;
                    yankedReason: z.ZodNullable<z.ZodString>;
                    urls: z.ZodEffects<z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        kind: z.ZodString;
                    }, "strip", z.ZodTypeAny, {
                        url: string;
                        kind: string;
                    }, {
                        url: string;
                        kind: string;
                    }>, "many">>>, {
                        [k: string]: string;
                    }, {
                        url: string;
                        kind: string;
                    }[] | undefined>;
                }, "strip", z.ZodTypeAny, {
                    urls: {
                        [k: string]: string;
                    };
                    version: string;
                    createdAt: string | null;
                    yankedReason: string | null;
                }, {
                    version: string;
                    createdAt: string | null;
                    yankedReason: string | null;
                    urls?: {
                        url: string;
                        kind: string;
                    }[] | undefined;
                }>, "many">;
            }, "strip", z.ZodTypeAny, {
                page: {
                    urls: {
                        [k: string]: string;
                    };
                    version: string;
                    createdAt: string | null;
                    yankedReason: string | null;
                }[];
                pages: number;
            }, {
                page: {
                    version: string;
                    createdAt: string | null;
                    yankedReason: string | null;
                    urls?: {
                        url: string;
                        kind: string;
                    }[] | undefined;
                }[];
                pages: number;
            }>>;
        }, "strip", z.ZodTypeAny, {
            variants: {
                page: {
                    urls: {
                        [k: string]: string;
                    };
                    version: string;
                    createdAt: string | null;
                    yankedReason: string | null;
                }[];
                pages: number;
            } | null;
        }, {
            variants: {
                page: {
                    version: string;
                    createdAt: string | null;
                    yankedReason: string | null;
                    urls?: {
                        url: string;
                        kind: string;
                    }[] | undefined;
                }[];
                pages: number;
            } | null;
        }>>;
    }, "strip", z.ZodTypeAny, {
        package: {
            variants: {
                page: {
                    urls: {
                        [k: string]: string;
                    };
                    version: string;
                    createdAt: string | null;
                    yankedReason: string | null;
                }[];
                pages: number;
            } | null;
        } | null;
    }, {
        package: {
            variants: {
                page: {
                    version: string;
                    createdAt: string | null;
                    yankedReason: string | null;
                    urls?: {
                        url: string;
                        kind: string;
                    }[] | undefined;
                }[];
                pages: number;
            } | null;
        } | null;
    }>;
}, "strip", z.ZodTypeAny, {
    data: {
        package: {
            variants: {
                page: {
                    urls: {
                        [k: string]: string;
                    };
                    version: string;
                    createdAt: string | null;
                    yankedReason: string | null;
                }[];
                pages: number;
            } | null;
        } | null;
    };
}, {
    data: {
        package: {
            variants: {
                page: {
                    version: string;
                    createdAt: string | null;
                    yankedReason: string | null;
                    urls?: {
                        url: string;
                        kind: string;
                    }[] | undefined;
                }[];
                pages: number;
            } | null;
        } | null;
    };
}>;
