import { GithubHttp } from '../../../util/http/github';
import { Datasource } from '../datasource';
import type { DigestConfig, GetReleasesConfig, ReleaseResult } from '../types';
export declare class ConanDatasource extends Datasource {
    static readonly id = "conan";
    readonly defaultRegistryUrls: string[];
    readonly caching = true;
    readonly registryStrategy = "merge";
    githubHttp: GithubHttp;
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is supported only if the package is served from the Artifactory servers. In which case we determine it from the `properties[conan.package.url]` field in the results.";
    constructor(id?: string);
    getConanCenterReleases(conanName: string, userAndChannel: string): Promise<ReleaseResult | null>;
    getDigest({ registryUrl, packageName }: DigestConfig, newValue?: string): Promise<string | null>;
    getReleases({ registryUrl, packageName, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
