"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CdnjsAPISriResponseSchema = exports.CdnjsAPIVersionResponseSchema = exports.Sri = exports.Versions = exports.Repository = exports.Homepage = void 0;
const zod_1 = require("zod");
exports.Homepage = zod_1.z.string().optional().catch(undefined);
exports.Repository = zod_1.z
    .object({
    type: zod_1.z.literal('git'),
    url: zod_1.z.string(),
})
    .transform(({ url }) => url)
    .optional()
    .catch(undefined);
exports.Versions = zod_1.z
    .string()
    .transform((version) => ({ version }))
    .array();
exports.Sri = zod_1.z.record(zod_1.z.string());
exports.CdnjsAPIVersionResponseSchema = zod_1.z.object({
    homepage: exports.Homepage,
    repository: exports.Repository,
    versions: exports.Versions,
});
exports.CdnjsAPISriResponseSchema = zod_1.z.object({
    sri: exports.Sri,
});
//# sourceMappingURL=schema.js.map