import { GithubHttp } from '../../../util/http/github';
import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class BitriseDatasource extends Datasource {
    static readonly id = "bitrise";
    readonly http: GithubHttp;
    constructor();
    readonly customRegistrySupport = true;
    readonly defaultRegistryUrls: string[];
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `published_at` field in the results.";
    readonly sourceUrlSupport = "release";
    readonly sourceUrlNote = "The source URL is determined from the `source_code_url` field of the release object in the results.";
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
