import type { PackageCacheNamespace } from '../../../util/cache/package/types';
import { BitbucketHttp } from '../../../util/http/bitbucket';
import { Datasource } from '../datasource';
import type { DigestConfig, GetReleasesConfig, ReleaseResult } from '../types';
export declare class BitbucketTagsDatasource extends Datasource {
    static readonly id = "bitbucket-tags";
    bitbucketHttp: BitbucketHttp;
    static readonly customRegistrySupport = true;
    static readonly registryStrategy = "first";
    static readonly defaultRegistryUrls: string[];
    static readonly releaseTimestampSupport = true;
    static readonly releaseTimestampNote = "The release timestamp is determined from the `date` field in the results.";
    static readonly sourceUrlSupport = "package";
    static readonly sourceUrlNote = "The source URL is determined by using the `packageName` and `registryUrl`.";
    static readonly cacheNamespace: PackageCacheNamespace;
    constructor();
    static getRegistryURL(registryUrl?: string): string;
    static getCacheKey(registryUrl: string | undefined, repo: string, type: string): string;
    static getSourceUrl(packageName: string, registryUrl?: string): string;
    getReleases({ registryUrl, packageName: repo, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    getTagCommit(_registryUrl: string | undefined, repo: string, tag: string): Promise<string | null>;
    getMainBranch(_registryUrl: string, repo: string): Promise<string>;
    getDigest({ packageName: repo, registryUrl }: DigestConfig, newValue?: string): Promise<string | null>;
}
