import type { PackageCacheNamespace } from '../../../util/cache/package/types';
import { BitbucketServerHttp } from '../../../util/http/bitbucket-server';
import { Datasource } from '../datasource';
import type { DigestConfig, GetReleasesConfig, ReleaseResult } from '../types';
export declare class BitbucketServerTagsDatasource extends Datasource {
    static readonly id = "bitbucket-server-tags";
    http: BitbucketServerHttp;
    static readonly sourceUrlSupport = "package";
    static readonly sourceUrlNote = "The source URL is determined by using the `packageName` and `registryUrl`.";
    static readonly cacheNamespace: PackageCacheNamespace;
    constructor();
    static getRegistryURL(registryUrl: string): string;
    static getSourceUrl(projectKey: string, repositorySlug: string, registryUrl: string): string;
    static getApiUrl(registryUrl: string): string;
    static getCacheKey(registryUrl: string | undefined, repo: string, type: string): string;
    getReleases(config: GetReleasesConfig): Promise<ReleaseResult | null>;
    getTagCommit(baseUrl: string, tag: string): Promise<string | null>;
    getDigest(config: DigestConfig, newValue?: string): Promise<string | null>;
}
