import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class BazelDatasource extends Datasource {
    static readonly id = "bazel";
    static readonly bazelCentralRepoUrl = "https://raw.githubusercontent.com/bazelbuild/bazel-central-registry/main";
    readonly defaultRegistryUrls: string[];
    readonly registryStrategy = "hunt";
    readonly customRegistrySupport = true;
    readonly caching = true;
    readonly defaultVersioning = "bazel-module";
    static packageMetadataPath(packageName: string): string;
    constructor();
    getReleases({ registryUrl, packageName, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
