"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BicepResourceVersionIndex = void 0;
const zod_1 = require("zod");
exports.BicepResourceVersionIndex = zod_1.z
    .object({
    resources: zod_1.z.record(zod_1.z.string(), zod_1.z.unknown()),
})
    .transform(({ resources }) => {
    const releaseMap = new Map();
    for (const resourceReference of Object.keys(resources)) {
        const [type, version] = resourceReference.toLowerCase().split('@', 2);
        const versions = releaseMap.get(type) ?? [];
        versions.push(version);
        releaseMap.set(type, versions);
    }
    return Object.fromEntries(releaseMap);
});
//# sourceMappingURL=schema.js.map