import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
import { BicepResourceVersionIndex } from './schema';
export declare class AzureBicepResourceDatasource extends Datasource {
    static readonly id = "azure-bicep-resource";
    readonly defaultConfig: {
        commitMessageTopic: string;
        commitMessageExtra: string;
        prBodyColumns: string[];
        prBodyDefinitions: {
            Resource: string;
        };
    };
    readonly defaultVersioning = "azure-rest-api";
    constructor();
    private getChangelogUrl;
    getReleases(getReleasesConfig: GetReleasesConfig): Promise<ReleaseResult | null>;
    getResourceVersionIndex(): Promise<BicepResourceVersionIndex>;
}
